%------------------------------------------------------------------------------
% File     : LCL967^3 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Logic Calculi
% Problem  : Goedel translation of SWV077+1 (from TPTP-v5.0.0)
% Version  : [BP13] axioms.
% English  : 

% Refs     : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : GSV077+1 [QMLTP]

% Status   : CounterSatisfiable
% Rating   : 1.00 v8.1.0
% Syntax   : Number of formulae    :  194 (  11 unt;  49 typ;  10 def)
%            Number of atoms       : 1925 (  10 equ;   0 cnn)
%            Maximal formula atoms :   97 (  13 avg)
%            Number of connectives : 3087 (   1   ~;   1   |;   2   &;3080   @)
%                                         (   1 <=>;   2  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   51 (  15 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :  111 ( 111   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   49 (  48 usr;  13 con; 0-4 aty)
%            Number of variables   :  357 ( 351   ^;   3   !;   3   ?; 357   :)
% SPC      : TH0_CSA_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $constant,
%            $modalities == $modal_system_D].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_serial,axiom,
    ! [W: mworld] :
    ? [V: mworld] : ( mrel @ W @ V ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] : ( A @ X @ W ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] : ( A @ X @ W ) ) ) ).

thf(typedecl_customqmltpeq,type,
    customqmltpeq: $i > $i > mworld > $o ).

thf(true_decl,type,
    true: mworld > $o ).

thf(def_decl,type,
    def: $i ).

thf(tptp_minus_1_decl,type,
    tptp_minus_1: $i ).

thf(pv40_decl,type,
    pv40: $i ).

thf(tptp_float_0_0_decl,type,
    tptp_float_0_0: $i ).

thf(n0_decl,type,
    n0: $i ).

thf(n1_decl,type,
    n1: $i ).

thf(n2_decl,type,
    n2: $i ).

thf(n3_decl,type,
    n3: $i ).

thf(n4_decl,type,
    n4: $i ).

thf(use_decl,type,
    use: $i ).

thf(n5_decl,type,
    n5: $i ).

thf(pv31_decl,type,
    pv31: $i ).

thf(geq_decl,type,
    geq: $i > $i > mworld > $o ).

thf(lt_decl,type,
    lt: $i > $i > mworld > $o ).

thf(leq_decl,type,
    leq: $i > $i > mworld > $o ).

thf(gt_decl,type,
    gt: $i > $i > mworld > $o ).

thf(minus_decl,type,
    minus: $i > $i > $i ).

thf(dim_decl,type,
    dim: $i > $i > $i ).

thf(sum_decl,type,
    sum: $i > $i > $i > $i ).

thf(plus_decl,type,
    plus: $i > $i > $i ).

thf(inv_decl,type,
    inv: $i > $i ).

thf(uniform_int_rnd_decl,type,
    uniform_int_rnd: $i > $i > $i ).

thf(succ_decl,type,
    succ: $i > $i ).

thf(pred_decl,type,
    pred: $i > $i ).

thf(tptp_update3_decl,type,
    tptp_update3: $i > $i > $i > $i > $i ).

thf(tptp_update2_decl,type,
    tptp_update2: $i > $i > $i > $i ).

thf(tptp_const_array1_decl,type,
    tptp_const_array1: $i > $i > $i ).

thf(tptp_mmul_decl,type,
    tptp_mmul: $i > $i > $i ).

thf(a_select3_decl,type,
    a_select3: $i > $i > $i > $i ).

thf(tptp_const_array2_decl,type,
    tptp_const_array2: $i > $i > $i > $i ).

thf(a_select2_decl,type,
    a_select2: $i > $i > $i ).

thf(tptp_madd_decl,type,
    tptp_madd: $i > $i > $i ).

thf(tptp_msub_decl,type,
    tptp_msub: $i > $i > $i ).

thf(trans_decl,type,
    trans: $i > $i ).

thf(reflexivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ X @ X ) ) ) ) ) ).

thf(symmetry,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ X @ Y ) ) @ ( mbox @ ( customqmltpeq @ Y @ X ) ) ) ) ) ) ) ) ) ).

thf(transitivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ X @ Y ) ) @ ( mbox @ ( customqmltpeq @ Y @ Z ) ) ) @ ( mbox @ ( customqmltpeq @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ).

thf(a_select2_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( a_select2 @ A @ C ) @ ( a_select2 @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(a_select2_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( a_select2 @ C @ A ) @ ( a_select2 @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(a_select3_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ A @ C @ D ) @ ( a_select3 @ B @ C @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(a_select3_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ C @ A @ D ) @ ( a_select3 @ C @ B @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(a_select3_substitution_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ C @ D @ A ) @ ( a_select3 @ C @ D @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(dim_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( dim @ A @ C ) @ ( dim @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(dim_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( dim @ C @ A ) @ ( dim @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(inv_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( inv @ A ) @ ( inv @ B ) ) ) ) ) ) ) ) ) ) ).

thf(minus_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( minus @ A @ C ) @ ( minus @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(minus_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( minus @ C @ A ) @ ( minus @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(plus_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( plus @ A @ C ) @ ( plus @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(plus_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( plus @ C @ A ) @ ( plus @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(pred_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( pred @ A ) @ ( pred @ B ) ) ) ) ) ) ) ) ) ) ).

thf(succ_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( succ @ A ) @ ( succ @ B ) ) ) ) ) ) ) ) ) ) ).

thf(sum_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( sum @ A @ C @ D ) @ ( sum @ B @ C @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(sum_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( sum @ C @ A @ D ) @ ( sum @ C @ B @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(sum_substitution_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( sum @ C @ D @ A ) @ ( sum @ C @ D @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_const_array1_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_const_array1 @ A @ C ) @ ( tptp_const_array1 @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_const_array1_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_const_array1 @ C @ A ) @ ( tptp_const_array1 @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_const_array2_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_const_array2 @ A @ C @ D ) @ ( tptp_const_array2 @ B @ C @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_const_array2_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_const_array2 @ C @ A @ D ) @ ( tptp_const_array2 @ C @ B @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_const_array2_substitution_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_const_array2 @ C @ D @ A ) @ ( tptp_const_array2 @ C @ D @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_madd_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_madd @ A @ C ) @ ( tptp_madd @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_madd_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_madd @ C @ A ) @ ( tptp_madd @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_mmul_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_mmul @ A @ C ) @ ( tptp_mmul @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_mmul_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_mmul @ C @ A ) @ ( tptp_mmul @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_msub_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_msub @ A @ C ) @ ( tptp_msub @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_msub_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_msub @ C @ A ) @ ( tptp_msub @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_update2_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_update2 @ A @ C @ D ) @ ( tptp_update2 @ B @ C @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_update2_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_update2 @ C @ A @ D ) @ ( tptp_update2 @ C @ B @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_update2_substitution_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_update2 @ C @ D @ A ) @ ( tptp_update2 @ C @ D @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_update3_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [E: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_update3 @ A @ C @ D @ E ) @ ( tptp_update3 @ B @ C @ D @ E ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_update3_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [E: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_update3 @ C @ A @ D @ E ) @ ( tptp_update3 @ C @ B @ D @ E ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_update3_substitution_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [E: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_update3 @ C @ D @ A @ E ) @ ( tptp_update3 @ C @ D @ B @ E ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(tptp_update3_substitution_4,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [E: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( tptp_update3 @ C @ D @ E @ A ) @ ( tptp_update3 @ C @ D @ E @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(trans_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( trans @ A ) @ ( trans @ B ) ) ) ) ) ) ) ) ) ) ).

thf(uniform_int_rnd_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( uniform_int_rnd @ A @ C ) @ ( uniform_int_rnd @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(uniform_int_rnd_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( customqmltpeq @ ( uniform_int_rnd @ C @ A ) @ ( uniform_int_rnd @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(geq_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( geq @ A @ C ) ) ) @ ( mbox @ ( geq @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(geq_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( geq @ C @ A ) ) ) @ ( mbox @ ( geq @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(gt_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( gt @ A @ C ) ) ) @ ( mbox @ ( gt @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(gt_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( gt @ C @ A ) ) ) @ ( mbox @ ( gt @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(leq_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( leq @ A @ C ) ) ) @ ( mbox @ ( leq @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(leq_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( leq @ C @ A ) ) ) @ ( mbox @ ( leq @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(lt_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( lt @ A @ C ) ) ) @ ( mbox @ ( lt @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(lt_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( customqmltpeq @ A @ B ) ) @ ( mbox @ ( lt @ C @ A ) ) ) @ ( mbox @ ( lt @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(totality,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mor @ ( mbox @ ( gt @ X @ Y ) ) @ ( mor @ ( mbox @ ( gt @ Y @ X ) ) @ ( mbox @ ( customqmltpeq @ X @ Y ) ) ) ) ) ) ) ) ) ).

thf(transitivity_gt,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( gt @ X @ Y ) ) @ ( mbox @ ( gt @ Y @ Z ) ) ) @ ( mbox @ ( gt @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ).

thf(irreflexivity_gt,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mnot @ ( mbox @ ( gt @ X @ X ) ) ) ) ) ) ) ).

thf(reflexivity_leq,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( leq @ X @ X ) ) ) ) ) ).

thf(transitivity_leq,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ X @ Y ) ) @ ( mbox @ ( leq @ Y @ Z ) ) ) @ ( mbox @ ( leq @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ).

thf(lt_gt,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( lt @ X @ Y ) ) @ ( mbox @ ( gt @ Y @ X ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( gt @ Y @ X ) ) @ ( mbox @ ( lt @ X @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(leq_geq,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( geq @ X @ Y ) ) @ ( mbox @ ( leq @ Y @ X ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( leq @ Y @ X ) ) @ ( mbox @ ( geq @ X @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(leq_gt1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( gt @ Y @ X ) ) @ ( mbox @ ( leq @ X @ Y ) ) ) ) ) ) ) ) ) ).

thf(leq_gt2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ X @ Y ) ) @ ( mbox @ ( mnot @ ( mbox @ ( customqmltpeq @ X @ Y ) ) ) ) ) @ ( mbox @ ( gt @ Y @ X ) ) ) ) ) ) ) ) ) ).

thf(leq_gt_pred,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( leq @ X @ ( pred @ Y ) ) ) @ ( mbox @ ( gt @ Y @ X ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( gt @ Y @ X ) ) @ ( mbox @ ( leq @ X @ ( pred @ Y ) ) ) ) ) ) ) ) ) ) ) ).

thf(gt_succ,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( gt @ ( succ @ X ) @ X ) ) ) ) ) ).

thf(leq_succ,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( leq @ X @ Y ) ) @ ( mbox @ ( leq @ X @ ( succ @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(leq_succ_gt_equiv,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( leq @ X @ Y ) ) @ ( mbox @ ( gt @ ( succ @ Y ) @ X ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( gt @ ( succ @ Y ) @ X ) ) @ ( mbox @ ( leq @ X @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(uniform_int_rand_ranges_hi,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ ( uniform_int_rnd @ C @ X ) @ X ) ) ) ) ) ) ) ) ) ).

thf(uniform_int_rand_ranges_lo,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ n0 @ ( uniform_int_rnd @ C @ X ) ) ) ) ) ) ) ) ) ) ).

thf(const_array1_select,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [I: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [L: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [U: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [Val: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ L @ I ) ) @ ( mbox @ ( leq @ I @ U ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select2 @ ( tptp_const_array1 @ ( dim @ L @ U ) @ Val ) @ I ) @ Val ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(const_array2_select,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [I: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [L1: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [U1: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [J: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [L2: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [U2: $i] :
                                          ( mbox
                                          @ ( mforall_di
                                            @ ^ [Val: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ L1 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ U1 ) ) @ ( mand @ ( mbox @ ( leq @ L2 @ J ) ) @ ( mbox @ ( leq @ J @ U2 ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_const_array2 @ ( dim @ L1 @ U1 ) @ ( dim @ L2 @ U2 ) @ Val ) @ I @ J ) @ Val ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_trans,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [N: $i] :
                  ( mbox
                  @ ( mimplies
                    @ ( mbox
                      @ ( mforall_di
                        @ ^ [I: $i] :
                            ( mbox
                            @ ( mforall_di
                              @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ A @ I @ J ) @ ( a_select3 @ A @ J @ I ) ) ) ) ) ) ) ) )
                    @ ( mbox
                      @ ( mforall_di
                        @ ^ [I: $i] :
                            ( mbox
                            @ ( mforall_di
                              @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( trans @ A ) @ I @ J ) @ ( a_select3 @ ( trans @ A ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_inv,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [N: $i] :
                  ( mbox
                  @ ( mimplies
                    @ ( mbox
                      @ ( mforall_di
                        @ ^ [I: $i] :
                            ( mbox
                            @ ( mforall_di
                              @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ A @ I @ J ) @ ( a_select3 @ A @ J @ I ) ) ) ) ) ) ) ) )
                    @ ( mbox
                      @ ( mforall_di
                        @ ^ [I: $i] :
                            ( mbox
                            @ ( mforall_di
                              @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( inv @ A ) @ I @ J ) @ ( a_select3 @ ( inv @ A ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_update_diagonal,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [N: $i] :
                  ( mbox
                  @ ( mimplies
                    @ ( mbox
                      @ ( mforall_di
                        @ ^ [I: $i] :
                            ( mbox
                            @ ( mforall_di
                              @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ A @ I @ J ) @ ( a_select3 @ A @ J @ I ) ) ) ) ) ) ) ) )
                    @ ( mbox
                      @ ( mforall_di
                        @ ^ [I: $i] :
                            ( mbox
                            @ ( mforall_di
                              @ ^ [J: $i] :
                                  ( mbox
                                  @ ( mforall_di
                                    @ ^ [K: $i] :
                                        ( mbox
                                        @ ( mforall_di
                                          @ ^ [VAL: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mand @ ( mbox @ ( leq @ J @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ K ) ) @ ( mbox @ ( leq @ K @ N ) ) ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_update3 @ A @ K @ K @ VAL ) @ I @ J ) @ ( a_select3 @ ( tptp_update3 @ A @ K @ K @ VAL ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_add,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [N: $i] :
                        ( mbox
                        @ ( mimplies
                          @ ( mand
                            @ ( mbox
                              @ ( mforall_di
                                @ ^ [I: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ A @ I @ J ) @ ( a_select3 @ A @ J @ I ) ) ) ) ) ) ) ) )
                            @ ( mbox
                              @ ( mforall_di
                                @ ^ [I: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ B @ I @ J ) @ ( a_select3 @ B @ J @ I ) ) ) ) ) ) ) ) ) )
                          @ ( mbox
                            @ ( mforall_di
                              @ ^ [I: $i] :
                                  ( mbox
                                  @ ( mforall_di
                                    @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_madd @ A @ B ) @ I @ J ) @ ( a_select3 @ ( tptp_madd @ A @ B ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_sub,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [N: $i] :
                        ( mbox
                        @ ( mimplies
                          @ ( mand
                            @ ( mbox
                              @ ( mforall_di
                                @ ^ [I: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ A @ I @ J ) @ ( a_select3 @ A @ J @ I ) ) ) ) ) ) ) ) )
                            @ ( mbox
                              @ ( mforall_di
                                @ ^ [I: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ B @ I @ J ) @ ( a_select3 @ B @ J @ I ) ) ) ) ) ) ) ) ) )
                          @ ( mbox
                            @ ( mforall_di
                              @ ^ [I: $i] :
                                  ( mbox
                                  @ ( mforall_di
                                    @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_msub @ A @ B ) @ I @ J ) @ ( a_select3 @ ( tptp_msub @ A @ B ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_aba1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [N: $i] :
                        ( mbox
                        @ ( mimplies
                          @ ( mbox
                            @ ( mforall_di
                              @ ^ [I: $i] :
                                  ( mbox
                                  @ ( mforall_di
                                    @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ B @ I @ J ) @ ( a_select3 @ B @ J @ I ) ) ) ) ) ) ) ) )
                          @ ( mbox
                            @ ( mforall_di
                              @ ^ [I: $i] :
                                  ( mbox
                                  @ ( mforall_di
                                    @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_mmul @ A @ ( tptp_mmul @ B @ ( trans @ A ) ) ) @ I @ J ) @ ( a_select3 @ ( tptp_mmul @ A @ ( tptp_mmul @ B @ ( trans @ A ) ) ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_aba2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [N: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [M: $i] :
                              ( mbox
                              @ ( mimplies
                                @ ( mbox
                                  @ ( mforall_di
                                    @ ^ [I: $i] :
                                        ( mbox
                                        @ ( mforall_di
                                          @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ M ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ M ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ B @ I @ J ) @ ( a_select3 @ B @ J @ I ) ) ) ) ) ) ) ) )
                                @ ( mbox
                                  @ ( mforall_di
                                    @ ^ [I: $i] :
                                        ( mbox
                                        @ ( mforall_di
                                          @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_mmul @ A @ ( tptp_mmul @ B @ ( trans @ A ) ) ) @ I @ J ) @ ( a_select3 @ ( tptp_mmul @ A @ ( tptp_mmul @ B @ ( trans @ A ) ) ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(matrix_symm_joseph_update,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [E: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [F: $i] :
                                          ( mbox
                                          @ ( mforall_di
                                            @ ^ [N: $i] :
                                                ( mbox
                                                @ ( mforall_di
                                                  @ ^ [M: $i] :
                                                      ( mbox
                                                      @ ( mimplies
                                                        @ ( mand
                                                          @ ( mbox
                                                            @ ( mforall_di
                                                              @ ^ [I: $i] :
                                                                  ( mbox
                                                                  @ ( mforall_di
                                                                    @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ M ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ M ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ D @ I @ J ) @ ( a_select3 @ D @ J @ I ) ) ) ) ) ) ) ) )
                                                          @ ( mand
                                                            @ ( mbox
                                                              @ ( mforall_di
                                                                @ ^ [I: $i] :
                                                                    ( mbox
                                                                    @ ( mforall_di
                                                                      @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ A @ I @ J ) @ ( a_select3 @ A @ J @ I ) ) ) ) ) ) ) ) )
                                                            @ ( mbox
                                                              @ ( mforall_di
                                                                @ ^ [I: $i] :
                                                                    ( mbox
                                                                    @ ( mforall_di
                                                                      @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ F @ I @ J ) @ ( a_select3 @ F @ J @ I ) ) ) ) ) ) ) ) ) ) )
                                                        @ ( mbox
                                                          @ ( mforall_di
                                                            @ ^ [I: $i] :
                                                                ( mbox
                                                                @ ( mforall_di
                                                                  @ ^ [J: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ N ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ N ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_madd @ A @ ( tptp_mmul @ B @ ( tptp_mmul @ ( tptp_madd @ ( tptp_mmul @ C @ ( tptp_mmul @ D @ ( trans @ C ) ) ) @ ( tptp_mmul @ E @ ( tptp_mmul @ F @ ( trans @ E ) ) ) ) @ ( trans @ B ) ) ) ) @ I @ J ) @ ( a_select3 @ ( tptp_madd @ A @ ( tptp_mmul @ B @ ( tptp_mmul @ ( tptp_madd @ ( tptp_mmul @ C @ ( tptp_mmul @ D @ ( trans @ C ) ) ) @ ( tptp_mmul @ E @ ( tptp_mmul @ F @ ( trans @ E ) ) ) ) @ ( trans @ B ) ) ) ) @ J @ I ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(sum_plus_base,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [Body: $i] : ( mbox @ ( customqmltpeq @ ( sum @ n0 @ tptp_minus_1 @ Body ) @ n0 ) ) ) ) ) ).

thf(sum_plus_base_float,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [Body: $i] : ( mbox @ ( customqmltpeq @ tptp_float_0_0 @ ( sum @ n0 @ tptp_minus_1 @ Body ) ) ) ) ) ) ).

thf(succ_tptp_minus_1,axiom,
    mlocal @ ( mbox @ ( customqmltpeq @ ( succ @ tptp_minus_1 ) @ n0 ) ) ).

thf(succ_plus_1_r,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ X @ n1 ) @ ( succ @ X ) ) ) ) ) ) ).

thf(succ_plus_1_l,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ n1 @ X ) @ ( succ @ X ) ) ) ) ) ) ).

thf(succ_plus_2_r,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ X @ n2 ) @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ).

thf(succ_plus_2_l,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ n2 @ X ) @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ).

thf(succ_plus_3_r,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ X @ n3 ) @ ( succ @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ) ).

thf(succ_plus_3_l,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ n3 @ X ) @ ( succ @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ) ).

thf(succ_plus_4_r,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ X @ n4 ) @ ( succ @ ( succ @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ) ) ).

thf(succ_plus_4_l,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ n4 @ X ) @ ( succ @ ( succ @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ) ) ).

thf(succ_plus_5_r,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ X @ n5 ) @ ( succ @ ( succ @ ( succ @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ) ) ) ).

thf(succ_plus_5_l,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( plus @ n5 @ X ) @ ( succ @ ( succ @ ( succ @ ( succ @ ( succ @ X ) ) ) ) ) ) ) ) ) ) ).

thf(pred_minus_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( minus @ X @ n1 ) @ ( pred @ X ) ) ) ) ) ) ).

thf(pred_succ,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( pred @ ( succ @ X ) ) @ X ) ) ) ) ) ).

thf(succ_pred,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( customqmltpeq @ ( succ @ ( pred @ X ) ) @ X ) ) ) ) ) ).

thf(leq_succ_succ,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( leq @ ( succ @ X ) @ ( succ @ Y ) ) ) @ ( mbox @ ( leq @ X @ Y ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( leq @ X @ Y ) ) @ ( mbox @ ( leq @ ( succ @ X ) @ ( succ @ Y ) ) ) ) ) ) ) ) ) ) ) ).

thf(leq_succ_gt,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( leq @ ( succ @ X ) @ Y ) ) @ ( mbox @ ( gt @ Y @ X ) ) ) ) ) ) ) ) ) ).

thf(leq_minus,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( leq @ ( minus @ X @ Y ) @ X ) ) @ ( mbox @ ( leq @ n0 @ Y ) ) ) ) ) ) ) ) ) ).

thf(sel3_update_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [U: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [V: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [VAL: $i] : ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_update3 @ X @ U @ V @ VAL ) @ U @ V ) @ VAL ) ) ) ) ) ) ) ) ) ) ) ).

thf(sel3_update_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [I: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [J: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [U: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [V: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [X: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [VAL: $i] :
                                          ( mbox
                                          @ ( mforall_di
                                            @ ^ [VAL2: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( customqmltpeq @ I @ U ) ) ) ) @ ( mand @ ( mbox @ ( customqmltpeq @ J @ V ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ X @ U @ V ) @ VAL ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_update3 @ X @ I @ J @ VAL2 ) @ U @ V ) @ VAL ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(sel3_update_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [I: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [J: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [U: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [V: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [X: $i] :
                                    ( mbox
                                    @ ( mforall_di
                                      @ ^ [VAL: $i] :
                                          ( mbox
                                          @ ( mimplies
                                            @ ( mand
                                              @ ( mbox
                                                @ ( mforall_di
                                                  @ ^ [I0: $i] :
                                                      ( mbox
                                                      @ ( mforall_di
                                                        @ ^ [J0: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I0 ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J0 ) ) @ ( mand @ ( mbox @ ( leq @ I0 @ U ) ) @ ( mbox @ ( leq @ J0 @ V ) ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select3 @ X @ I0 @ J0 ) @ VAL ) ) ) ) ) ) ) )
                                              @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mand @ ( mbox @ ( leq @ I @ U ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ J ) ) @ ( mbox @ ( leq @ J @ V ) ) ) ) ) )
                                            @ ( mbox @ ( customqmltpeq @ ( a_select3 @ ( tptp_update3 @ X @ U @ V @ VAL ) @ I @ J ) @ VAL ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(sel2_update_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [U: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [VAL: $i] : ( mbox @ ( customqmltpeq @ ( a_select2 @ ( tptp_update2 @ X @ U @ VAL ) @ U ) @ VAL ) ) ) ) ) ) ) ) ) ).

thf(sel2_update_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [I: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [U: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [X: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [VAL: $i] :
                              ( mbox
                              @ ( mforall_di
                                @ ^ [VAL2: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( mnot @ ( mbox @ ( customqmltpeq @ I @ U ) ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select2 @ X @ U ) @ VAL ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select2 @ ( tptp_update2 @ X @ I @ VAL2 ) @ U ) @ VAL ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(sel2_update_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [I: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [U: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [X: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [VAL: $i] :
                              ( mbox
                              @ ( mimplies
                                @ ( mand
                                  @ ( mbox
                                    @ ( mforall_di
                                      @ ^ [I0: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ I0 ) ) @ ( mbox @ ( leq @ I0 @ U ) ) ) @ ( mbox @ ( customqmltpeq @ ( a_select2 @ X @ I0 ) @ VAL ) ) ) ) ) )
                                  @ ( mand @ ( mbox @ ( leq @ n0 @ I ) ) @ ( mbox @ ( leq @ I @ U ) ) ) )
                                @ ( mbox @ ( customqmltpeq @ ( a_select2 @ ( tptp_update2 @ X @ U @ VAL ) @ I ) @ VAL ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ttrue,axiom,
    mlocal @ ( mbox @ true ) ).

thf(defuse,axiom,
    mlocal @ ( mbox @ ( mnot @ ( mbox @ ( customqmltpeq @ def @ use ) ) ) ) ).

thf(cl5_nebula_array_0018,conjecture,
    mlocal @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ pv31 ) ) @ ( mbox @ ( leq @ pv31 @ ( minus @ n5 @ n1 ) ) ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ pv31 ) ) @ ( mand @ ( mbox @ ( leq @ pv31 @ ( minus @ n5 @ n1 ) ) ) @ ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( mnot @ ( mbox @ ( customqmltpeq @ n0 @ pv40 ) ) ) ) @ ( mand @ ( mbox @ ( leq @ n0 @ pv31 ) ) @ ( mbox @ ( leq @ pv31 @ ( minus @ n5 @ n1 ) ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mbox @ ( customqmltpeq @ n0 @ pv40 ) ) @ ( mbox @ true ) ) ) ) ) ) ) ) ).

thf(gt_5_4,axiom,
    mlocal @ ( mbox @ ( gt @ n5 @ n4 ) ) ).

thf(gt_4_tptp_minus_1,axiom,
    mlocal @ ( mbox @ ( gt @ n4 @ tptp_minus_1 ) ) ).

thf(gt_5_tptp_minus_1,axiom,
    mlocal @ ( mbox @ ( gt @ n5 @ tptp_minus_1 ) ) ).

thf(gt_0_tptp_minus_1,axiom,
    mlocal @ ( mbox @ ( gt @ n0 @ tptp_minus_1 ) ) ).

thf(gt_1_tptp_minus_1,axiom,
    mlocal @ ( mbox @ ( gt @ n1 @ tptp_minus_1 ) ) ).

thf(gt_2_tptp_minus_1,axiom,
    mlocal @ ( mbox @ ( gt @ n2 @ tptp_minus_1 ) ) ).

thf(gt_3_tptp_minus_1,axiom,
    mlocal @ ( mbox @ ( gt @ n3 @ tptp_minus_1 ) ) ).

thf(gt_4_0,axiom,
    mlocal @ ( mbox @ ( gt @ n4 @ n0 ) ) ).

thf(gt_5_0,axiom,
    mlocal @ ( mbox @ ( gt @ n5 @ n0 ) ) ).

thf(gt_1_0,axiom,
    mlocal @ ( mbox @ ( gt @ n1 @ n0 ) ) ).

thf(gt_2_0,axiom,
    mlocal @ ( mbox @ ( gt @ n2 @ n0 ) ) ).

thf(gt_3_0,axiom,
    mlocal @ ( mbox @ ( gt @ n3 @ n0 ) ) ).

thf(gt_4_1,axiom,
    mlocal @ ( mbox @ ( gt @ n4 @ n1 ) ) ).

thf(gt_5_1,axiom,
    mlocal @ ( mbox @ ( gt @ n5 @ n1 ) ) ).

thf(gt_2_1,axiom,
    mlocal @ ( mbox @ ( gt @ n2 @ n1 ) ) ).

thf(gt_3_1,axiom,
    mlocal @ ( mbox @ ( gt @ n3 @ n1 ) ) ).

thf(gt_4_2,axiom,
    mlocal @ ( mbox @ ( gt @ n4 @ n2 ) ) ).

thf(gt_5_2,axiom,
    mlocal @ ( mbox @ ( gt @ n5 @ n2 ) ) ).

thf(gt_3_2,axiom,
    mlocal @ ( mbox @ ( gt @ n3 @ n2 ) ) ).

thf(gt_4_3,axiom,
    mlocal @ ( mbox @ ( gt @ n4 @ n3 ) ) ).

thf(gt_5_3,axiom,
    mlocal @ ( mbox @ ( gt @ n5 @ n3 ) ) ).

thf(finite_domain_4,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ X @ n4 ) ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n0 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n1 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n2 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n3 ) ) @ ( mbox @ ( customqmltpeq @ X @ n4 ) ) ) ) ) ) ) ) ) ) ) ).

thf(finite_domain_5,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ X @ n5 ) ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n0 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n1 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n2 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n3 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n4 ) ) @ ( mbox @ ( customqmltpeq @ X @ n5 ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(finite_domain_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ X @ n0 ) ) ) @ ( mbox @ ( customqmltpeq @ X @ n0 ) ) ) ) ) ) ) ).

thf(finite_domain_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ X @ n1 ) ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n0 ) ) @ ( mbox @ ( customqmltpeq @ X @ n1 ) ) ) ) ) ) ) ) ).

thf(finite_domain_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ X @ n2 ) ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n0 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n1 ) ) @ ( mbox @ ( customqmltpeq @ X @ n2 ) ) ) ) ) ) ) ) ) ).

thf(finite_domain_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( leq @ n0 @ X ) ) @ ( mbox @ ( leq @ X @ n3 ) ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n0 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n1 ) ) @ ( mor @ ( mbox @ ( customqmltpeq @ X @ n2 ) ) @ ( mbox @ ( customqmltpeq @ X @ n3 ) ) ) ) ) ) ) ) ) ) ).

thf(successor_4,axiom,
    mlocal @ ( mbox @ ( customqmltpeq @ ( succ @ ( succ @ ( succ @ ( succ @ n0 ) ) ) ) @ n4 ) ) ).

thf(successor_5,axiom,
    mlocal @ ( mbox @ ( customqmltpeq @ ( succ @ ( succ @ ( succ @ ( succ @ ( succ @ n0 ) ) ) ) ) @ n5 ) ) ).

thf(successor_1,axiom,
    mlocal @ ( mbox @ ( customqmltpeq @ ( succ @ n0 ) @ n1 ) ) ).

thf(successor_2,axiom,
    mlocal @ ( mbox @ ( customqmltpeq @ ( succ @ ( succ @ n0 ) ) @ n2 ) ) ).

thf(successor_3,axiom,
    mlocal @ ( mbox @ ( customqmltpeq @ ( succ @ ( succ @ ( succ @ n0 ) ) ) @ n3 ) ) ).

%------------------------------------------------------------------------------
